
from dotenv import load_dotenv
from llama_index.core import VectorStoreIndex, SimpleDirectoryReader

load_dotenv()

# Wczytanie dokumentów do folderu z danymi i utworzenie indeksów
documents = SimpleDirectoryReader("files").load_data()
index = VectorStoreIndex.from_documents(documents)

# Zapytanie o dane
query_engine = index.as_query_engine()
response = query_engine.query("Co jest potrzebne do zbudowania drzwi?")
print(response)